<?php
declare(strict_types=1);
require_once __DIR__ . '/../core/bootstrap.php';
require_once __DIR__ . '/../core/OkxClient.php';
header('Content-Type: application/json; charset=utf-8');

try {
  if (!is_post()) throw new RuntimeException("POST only");
  csrf_check((string)($_POST['csrf'] ?? ''));

  $tradeId = (int)($_POST['trade_id'] ?? 0);
  $quoteSz = (float)($_POST['quote_sz'] ?? 0);

  if ($tradeId <= 0) throw new RuntimeException("Invalid trade id");
  if ($quoteSz < 5) throw new RuntimeException("Minimum spend is 5 USDT");
  if ($quoteSz > 500) throw new RuntimeException("Spend too high");

  $pdo = db();
  $settings = $pdo->query("SELECT * FROM settings ORDER BY id ASC LIMIT 1")->fetch();
  if ((int)($settings['kill_switch'] ?? 0) === 1) throw new RuntimeException("Kill switch ON. Trading paused.");

  $st = $pdo->prepare("SELECT * FROM trades WHERE id=? LIMIT 1");
  $st->execute([$tradeId]);
  $t = $st->fetch();
  if (!$t) throw new RuntimeException("Trade not found");
  if (($t['status'] ?? '') !== 'proposal') throw new RuntimeException("Not a proposal");

  $sec = $pdo->query("SELECT * FROM secrets ORDER BY id DESC LIMIT 1")->fetch();
  if (!$sec) throw new RuntimeException("Secrets missing");
  $okx = new OkxClient(dec_str($sec['okx_api_key']), dec_str($sec['okx_secret_key']), dec_str($sec['okx_passphrase']));

  $bal = $okx->balance('USDT');
  $avail = 0.0;
  if (!empty($bal['data'][0]['details'])) {
    foreach ($bal['data'][0]['details'] as $d) {
      if (($d['ccy'] ?? '') === 'USDT') { $avail = (float)($d['availBal'] ?? 0); break; }
    }
  }
  if ($avail < ($quoteSz + 0.5)) throw new RuntimeException("Not enough USDT. Available: ".$avail);

  $resp = $okx->placeSpotBuy((string)$t['pair'], number_format($quoteSz, 2, '.', ''));
  $ordId = $resp['data'][0]['ordId'] ?? null;

  $pdo->prepare("UPDATE trades SET qty=?, okx_order_id=?, status=?, reason=? WHERE id=?")
      ->execute([$quoteSz, $ordId, 'executed', trim((string)($t['reason'] ?? ''))." | Approved", $tradeId]);

  log_file("APPROVED trade #$tradeId {$t['pair']} spend={$quoteSz} ordId=".($ordId ?? ''));
  log_db("APPROVED trade #$tradeId {$t['pair']} spend={$quoteSz}");

  echo json_encode(['ok'=>true,'trade_id'=>$tradeId,'ordId'=>$ordId,'spent'=>$quoteSz], JSON_PRETTY_PRINT);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()], JSON_PRETTY_PRINT);
}
