<?php
declare(strict_types=1);
require_once __DIR__ . '/../core/bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

try {
  if (!is_post()) throw new RuntimeException("POST only");
  csrf_check((string)($_POST['csrf'] ?? ''));

  $tradeId = (int)($_POST['trade_id'] ?? 0);
  if ($tradeId <= 0) throw new RuntimeException("Invalid trade id");

  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM trades WHERE id=? LIMIT 1");
  $st->execute([$tradeId]);
  $t = $st->fetch();
  if (!$t) throw new RuntimeException("Trade not found");
  if (($t['status'] ?? '') !== 'proposal') throw new RuntimeException("Not a proposal");

  $pdo->prepare("UPDATE trades SET status=?, reason=? WHERE id=?")
      ->execute(['rejected', trim((string)($t['reason'] ?? ''))." | Rejected", $tradeId]);

  log_file("REJECTED trade #$tradeId {$t['pair']}");
  log_db("REJECTED trade #$tradeId {$t['pair']}");

  echo json_encode(['ok'=>true,'trade_id'=>$tradeId], JSON_PRETTY_PRINT);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()], JSON_PRETTY_PRINT);
}
