<?php
declare(strict_types=1);
require_once __DIR__ . '/../core/bootstrap.php';
require_once __DIR__ . '/../core/OkxClient.php';
header('Content-Type: application/json; charset=utf-8');

try {
  $row = db()->query("SELECT * FROM secrets ORDER BY id DESC LIMIT 1")->fetch();
  if (!$row) throw new RuntimeException("Secrets not set. Run install.php first.");
  $okx = new OkxClient(dec_str($row['okx_api_key']), dec_str($row['okx_secret_key']), dec_str($row['okx_passphrase']));
  $bal = $okx->balance('USDT');
  echo json_encode(['ok'=>true,'balance'=>$bal], JSON_PRETTY_PRINT);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()], JSON_PRETTY_PRINT);
}
