CREATE TABLE IF NOT EXISTS settings (
  id INT PRIMARY KEY AUTO_INCREMENT,
  mode ENUM('manual','auto') NOT NULL DEFAULT 'manual',
  risk_percent FLOAT NOT NULL DEFAULT 1,
  max_trades_per_day INT NOT NULL DEFAULT 1,
  daily_stop_percent FLOAT NOT NULL DEFAULT 2,
  weekly_stop_percent FLOAT NOT NULL DEFAULT 6,
  max_open_positions INT NOT NULL DEFAULT 1,
  allowed_pairs TEXT NOT NULL,
  kill_switch TINYINT(1) NOT NULL DEFAULT 0,
  min_usdt_balance FLOAT NOT NULL DEFAULT 5.5,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS secrets (
  id INT PRIMARY KEY AUTO_INCREMENT,
  okx_api_key TEXT NOT NULL,
  okx_secret_key TEXT NOT NULL,
  okx_passphrase TEXT NOT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS positions (
  id INT PRIMARY KEY AUTO_INCREMENT,
  pair VARCHAR(20) NOT NULL,
  side ENUM('buy') NOT NULL,
  qty DECIMAL(28,12) NOT NULL,
  entry_price DECIMAL(28,12) NOT NULL,
  status ENUM('open','closed') NOT NULL DEFAULT 'open',
  opened_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS trades (
  id INT PRIMARY KEY AUTO_INCREMENT,
  pair VARCHAR(20) NOT NULL,
  action ENUM('buy','sell') NOT NULL,
  qty DECIMAL(28,12) NOT NULL,
  price DECIMAL(28,12) DEFAULT NULL,
  okx_order_id VARCHAR(64) DEFAULT NULL,
  status VARCHAR(30) NOT NULL DEFAULT 'created',
  reason TEXT DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS logs (
  id INT PRIMARY KEY AUTO_INCREMENT,
  message TEXT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO settings (mode, risk_percent, max_trades_per_day, daily_stop_percent, weekly_stop_percent, max_open_positions, allowed_pairs, kill_switch, min_usdt_balance)
SELECT 'manual', 1, 1, 2, 6, 1, 'BTC-USDT,ETH-USDT,XRP-USDT', 0, 5.5
WHERE NOT EXISTS (SELECT 1 FROM settings);
