<?php
declare(strict_types=1);
require_once __DIR__ . '/core/bootstrap.php';

$errors = [];
$done = false;
$exists = file_exists(__DIR__ . "/config/config.local.php");

if (is_post()) {
  $db_host = trim($_POST['db_host'] ?? 'localhost');
  $db_name = trim($_POST['db_name'] ?? '');
  $db_user = trim($_POST['db_user'] ?? '');
  $db_pass = (string)($_POST['db_pass'] ?? '');
  $app_url = trim($_POST['app_url'] ?? '');

  $okx_key = trim($_POST['okx_key'] ?? '');
  $okx_secret = trim($_POST['okx_secret'] ?? '');
  $okx_passphrase = trim($_POST['okx_passphrase'] ?? '');

  if ($db_name === '' || $db_user === '' || $app_url === '') $errors[] = "Please fill DB + App URL.";
  if ($okx_key === '' || $okx_secret === '' || $okx_passphrase === '') $errors[] = "Please fill OKX API credentials.";

  if (!$errors) {
    $cfg = "<?php\nreturn [\n".
      "  'db' => [\n".
      "    'host' => ".var_export($db_host,true).",\n".
      "    'name' => ".var_export($db_name,true).",\n".
      "    'user' => ".var_export($db_user,true).",\n".
      "    'pass' => ".var_export($db_pass,true).",\n".
      "  ],\n".
      "  'app_key' => ".var_export("rzRm7tnAmV8B7fKYjE4v80rAGfcRQgSY",true).",\n".
      "  'app_url' => ".var_export($app_url,true).",\n".
      "];\n";
    if (!$exists) {
      file_put_contents(__DIR__ . "/config/config.local.php", $cfg);
    }

    $pdo = db();
    $pdo->exec(file_get_contents(__DIR__ . "/engine/schema.sql"));

    $pdo->prepare("INSERT INTO secrets(okx_api_key, okx_secret_key, okx_passphrase) VALUES (?,?,?)")
        ->execute([enc_str($okx_key), enc_str($okx_secret), enc_str($okx_passphrase)]);

    $done = true;
  }
}
?>
<!doctype html>
<html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Install - Hawlerakam AI Trader</title>
<style>
body{font-family:system-ui,Segoe UI,Arial;background:#0b0f19;color:#e6e9f2;padding:20px}
.card{max-width:780px;margin:0 auto;background:#121a2a;border:1px solid #22304f;border-radius:14px;padding:18px}
input{width:100%;padding:10px;border-radius:10px;border:1px solid #2a3b63;background:#0b1020;color:#e6e9f2}
label{display:block;margin-top:12px;margin-bottom:6px}
button{margin-top:16px;padding:10px 14px;border-radius:12px;border:0;background:#2b6cff;color:#fff;font-weight:700;cursor:pointer}
.err{background:#3a1b1b;border:1px solid #6b2a2a;padding:10px;border-radius:12px;margin-bottom:12px}
.warn{background:#3a2e12;border:1px solid #6b532a;padding:10px;border-radius:12px;margin-bottom:12px}
.ok{background:#14351e;border:1px solid #2a6b3a;padding:12px;border-radius:12px}
a{color:#9ad1ff}
</style></head><body>
<div class="card">
<h2>Hawlerakam AI Trader - Install</h2>
<p><small>After install, delete <b>install.php</b></small></p>

<?php if ($exists): ?>
<div class="warn"><b>Config detected:</b> <code>config/config.local.php</code> already exists.<br>✅ This installer will <b>NOT overwrite</b> it (safe upgrade).</div>
<?php endif; ?>

<?php if ($errors): ?>
<div class="err"><b>Fix these:</b><ul><?php foreach($errors as $e): ?><li><?=h($e)?></li><?php endforeach; ?></ul></div>
<?php endif; ?>

<?php if ($done): ?>
<div class="ok">✅ Installed successfully.<br><br><a href="public/">Open Dashboard</a></div>
<?php else: ?>
<form method="post">
<h3>Database</h3>
<label>DB Host</label><input name="db_host" value="<?=h($_POST['db_host'] ?? 'localhost')?>">
<label>DB Name</label><input name="db_name" value="<?=h($_POST['db_name'] ?? '')?>" placeholder="hawlerakam_Ai">
<label>DB User</label><input name="db_user" value="<?=h($_POST['db_user'] ?? '')?>" placeholder="hawlerakam_iAi2026">
<label>DB Password</label><input name="db_pass" type="password" value="<?=h($_POST['db_pass'] ?? '')?>">
<h3 style="margin-top:18px">App</h3>
<label>App URL</label><input name="app_url" value="<?=h($_POST['app_url'] ?? '')?>" placeholder="https://ai.hawlerakam.com">
<h3 style="margin-top:18px">OKX API</h3>
<label>API Key</label><input name="okx_key" value="<?=h($_POST['okx_key'] ?? '')?>">
<label>Secret Key</label><input name="okx_secret" type="password" value="<?=h($_POST['okx_secret'] ?? '')?>">
<label>Passphrase</label><input name="okx_passphrase" type="password" value="<?=h($_POST['okx_passphrase'] ?? '')?>">
<button type="submit">Install</button>
</form>
<?php endif; ?>
</div></body></html>
