<?php
declare(strict_types=1);
require_once __DIR__ . '/../core/bootstrap.php';
try { $pdo = db(); } catch(Throwable $e) { header('Location: ../install.php'); exit; }

$settings = $pdo->query("SELECT * FROM settings ORDER BY id ASC LIMIT 1")->fetch();
$proposals = $pdo->query("SELECT * FROM trades WHERE status='proposal' ORDER BY id DESC LIMIT 50")->fetchAll();
$csrf = csrf_token();
?>
<!doctype html>
<html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Approvals - Hawlerakam AI Trader</title>
<style>
body{font-family:system-ui,Segoe UI,Arial;background:#0b0f19;color:#e6e9f2;margin:0;padding:18px}
.wrap{max-width:980px;margin:0 auto}
.card{background:#121a2a;border:1px solid #22304f;border-radius:16px;padding:14px;margin-top:12px}
table{width:100%;border-collapse:collapse}
td,th{padding:8px;border-bottom:1px solid #22304f;text-align:left;font-size:14px}
.muted{opacity:.85}
.btn{padding:9px 12px;border-radius:12px;border:0;cursor:pointer;font-weight:900}
.btn-green{background:#1f7a42;color:#fff}.btn-red{background:#ff3b3b;color:#fff}
input{padding:8px;border-radius:12px;border:1px solid #2a3b63;background:#0b1020;color:#e6e9f2;width:110px}
a{color:#9ad1ff;text-decoration:none}a:hover{text-decoration:underline}
.warn{background:#3a2e12;border:1px solid #6b532a;padding:10px;border-radius:12px}
</style></head><body>
<div class="wrap">
  <div style="display:flex;justify-content:space-between;gap:10px;flex-wrap:wrap;align-items:center">
    <div>
      <h2 style="margin:0">Trade Approvals</h2>
      <div class="muted">Approve / Reject proposals • OKX Spot</div>
    </div>
    <div><a class="muted" href="index.php">← Back to Dashboard</a></div>
  </div>

  <?php if ((int)($settings['kill_switch'] ?? 0) === 1): ?>
    <div class="card warn"><b>Kill switch is ON</b> — approvals are blocked until you turn it OFF in Dashboard.</div>
  <?php endif; ?>

  <div class="card">
    <h3 style="margin-top:0">Pending Proposals (<?=h((string)count($proposals))?>)</h3>
    <table>
      <thead><tr><th>ID</th><th>Pair</th><th>Price</th><th>Reason</th><th>Spend (USDT)</th><th>Actions</th><th>Time</th></tr></thead>
      <tbody>
      <?php foreach($proposals as $p): ?>
        <tr>
          <td><?=h((string)$p['id'])?></td>
          <td><?=h($p['pair'])?></td>
          <td><?=h((string)$p['price'])?></td>
          <td class="muted"><?=h((string)$p['reason'])?></td>
          <td><input id="sz<?=h((string)$p['id'])?>" type="number" step="0.01" min="5" value="5.00"></td>
          <td style="display:flex;gap:8px;flex-wrap:wrap">
            <button class="btn btn-green" onclick="approve(<?=h((string)$p['id'])?>)">Approve</button>
            <button class="btn btn-red" onclick="rejectTrade(<?=h((string)$p['id'])?>)">Reject</button>
          </td>
          <td><?=h($p['created_at'])?></td>
        </tr>
      <?php endforeach; ?>
      <?php if(!$proposals): ?><tr><td colspan="7" class="muted">No pending proposals right now.</td></tr><?php endif; ?>
      </tbody>
    </table>
    <div class="muted" style="margin-top:10px">Tip: start with <b>5 USDT</b> for testing.</div>
  </div>
</div>

<script>
const CSRF = <?=json_encode($csrf)?>;

async function approve(id){
  const v = document.getElementById('sz'+id).value;
  const fd = new FormData();
  fd.append('csrf', CSRF);
  fd.append('trade_id', id);
  fd.append('quote_sz', v);
  const res = await fetch('../api/approve.php', {method:'POST', body:fd});
  const j = await res.json();
  if(!j.ok){ alert("Approve failed: " + j.error); return; }
  alert("Approved ✅\nTrade #" + j.trade_id + "\nSpent: " + j.spent + " USDT\nOrderId: " + (j.ordId || ""));
  location.reload();
}
async function rejectTrade(id){
  if(!confirm("Reject proposal #" + id + "?")) return;
  const fd = new FormData();
  fd.append('csrf', CSRF);
  fd.append('trade_id', id);
  const res = await fetch('../api/reject.php', {method:'POST', body:fd});
  const j = await res.json();
  if(!j.ok){ alert("Reject failed: " + j.error); return; }
  alert("Rejected ✅ Trade #" + j.trade_id);
  location.reload();
}
</script>
</body></html>
