<?php
declare(strict_types=1);
require_once __DIR__ . '/../core/bootstrap.php';

try { $pdo = db(); ensure_schema_migrations($pdo); } catch(Throwable $e) { header('Location: ../install.php'); exit; }
$settings = $pdo->query("SELECT * FROM settings ORDER BY id ASC LIMIT 1")->fetch();
if (!$settings) { header('Location: ../install.php'); exit; }

$msg = null;
if (is_post()) {
  if (isset($_POST['toggle_mode'])) {
    $newMode = ($_POST['mode'] === 'auto') ? 'auto' : 'manual';
    $pdo->prepare("UPDATE settings SET mode=? WHERE id=?")->execute([$newMode, $settings['id']]);
    $msg = "Mode updated to $newMode";
  }
  if (isset($_POST['toggle_kill'])) {
    $kill = (int)($_POST['kill_switch'] ?? 0);
    $pdo->prepare("UPDATE settings SET kill_switch=? WHERE id=?")->execute([$kill, $settings['id']]);
    $msg = $kill ? "Kill switch ON (paused)" : "Kill switch OFF";
  }
  if (isset($_POST['save_limits'])) {
    $risk = max(0.1, min(5.0, (float)($_POST['risk_percent'] ?? 1)));
    $mtd = max(0, min(20, (int)($_POST['max_trades_per_day'] ?? 1)));
    $daily = max(0.5, min(20, (float)($_POST['daily_stop_percent'] ?? 2)));
    $weekly = max(1, min(50, (float)($_POST['weekly_stop_percent'] ?? 6)));
    $maxpos = max(1, min(5, (int)($_POST['max_open_positions'] ?? 1)));
    $pairs = trim((string)($_POST['allowed_pairs'] ?? 'BTC-USDT,ETH-USDT,XRP-USDT'));
    $minbal = max(0, min(1000, (float)($_POST['min_usdt_balance'] ?? 5.5)));
    $pdo->prepare("UPDATE settings SET risk_percent=?, max_trades_per_day=?, daily_stop_percent=?, weekly_stop_percent=?, max_open_positions=?, allowed_pairs=? WHERE id=?")
        ->execute([$risk,$mtd,$daily,$weekly,$maxpos,$pairs,$settings['id']]);
    $msg = "Limits saved";
  }
  $settings = $pdo->query("SELECT * FROM settings ORDER BY id ASC LIMIT 1")->fetch();
}

$pending = (int)($pdo->query("SELECT COUNT(*) c FROM trades WHERE status='proposal'")->fetch()['c'] ?? 0);
$trades = $pdo->query("SELECT * FROM trades ORDER BY id DESC LIMIT 12")->fetchAll();
$logs = $pdo->query("SELECT * FROM logs ORDER BY id DESC LIMIT 10")->fetchAll();
?>
<!doctype html>
<html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Hawlerakam AI Trader</title>
<style>
body{font-family:system-ui,Segoe UI,Arial;background:#0b0f19;color:#e6e9f2;margin:0;padding:18px}
.wrap{max-width:980px;margin:0 auto}
.top{display:flex;justify-content:space-between;gap:10px;flex-wrap:wrap;align-items:center}
.card{background:#121a2a;border:1px solid #22304f;border-radius:16px;padding:14px;margin-top:12px}
.grid{display:grid;grid-template-columns:repeat(12,1fr);gap:12px}
.col6{grid-column:span 6}.col12{grid-column:span 12}
@media(max-width:900px){.col6{grid-column:span 12}}
.btn{padding:10px 12px;border-radius:12px;border:0;cursor:pointer;font-weight:800}
.btn-blue{background:#2b6cff;color:#fff}.btn-red{background:#ff3b3b;color:#fff}.btn-gray{background:#2a3553;color:#fff}
input,textarea,select{width:100%;padding:10px;border-radius:12px;border:1px solid #2a3b63;background:#0b1020;color:#e6e9f2}
textarea{min-height:44px}
table{width:100%;border-collapse:collapse}
td,th{padding:8px;border-bottom:1px solid #22304f;text-align:left;font-size:14px}
.muted{opacity:.85}
.pill{display:inline-block;padding:6px 10px;border-radius:999px;border:1px solid #2a3b63;background:#0b1020}
.badge{display:inline-block;padding:3px 8px;border-radius:999px;background:#2b6cff;color:#fff;font-weight:800;font-size:12px}
a{color:#9ad1ff;text-decoration:none}a:hover{text-decoration:underline}
</style></head><body>
<div class="wrap">
  <div class="top">
    <div>
      <h2 style="margin:0">Hawlerakam AI Trader</h2>
      <div class="muted">OKX Spot • Manual/Auto • Cron Engine</div>
      <div style="margin-top:8px">
        <a class="pill" href="approvals.php">Approvals <?php if($pending>0): ?><span class="badge"><?=h((string)$pending)?></span><?php endif; ?></a>
      </div>
    </div>
    <div class="pill">Mode: <b><?=h($settings['mode'])?></b> • Kill: <b><?=((int)$settings['kill_switch']===1)?'ON':'OFF'?></b></div>
  </div>

  <?php if($msg): ?><div class="card"><b>✅ <?=h($msg)?></b></div><?php endif; ?>

  <div class="grid">
    <div class="card col6">
      <h3 style="margin-top:0">Controls</h3>
      <form method="post" style="display:flex;gap:10px;flex-wrap:wrap;align-items:center">
        <input type="hidden" name="toggle_mode" value="1">
        <select name="mode" style="max-width:220px">
          <option value="manual" <?=($settings['mode']==='manual'?'selected':'')?>>Manual (Approve)</option>
          <option value="auto" <?=($settings['mode']==='auto'?'selected':'')?>>Auto (Creates proposal)</option>
        </select>
        <button class="btn btn-blue" type="submit">Save Mode</button>
      </form>

      <form method="post" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;align-items:center">
        <input type="hidden" name="toggle_kill" value="1">
        <select name="kill_switch" style="max-width:220px">
          <option value="0" <?=((int)$settings['kill_switch']===0?'selected':'')?>>Kill switch OFF</option>
          <option value="1" <?=((int)$settings['kill_switch']===1?'selected':'')?>>Kill switch ON (Pause)</option>
        </select>
        <button class="btn btn-red" type="submit">Apply</button>
      </form>

      <div class="muted" style="margin-top:12px">
        Test OKX connection: <a href="../api/test_okx.php" target="_blank">/api/test_okx.php</a><br>
        Server outbound IP: <a href="../iptest.php" target="_blank">/iptest.php</a><br>
        Approvals: <a href="approvals.php">/public/approvals.php</a>
      </div>
    </div>

    <div class="card col6">
      <h3 style="margin-top:0">Limits</h3>
      <form method="post">
        <input type="hidden" name="save_limits" value="1">
        <label class="muted">Risk % (per trade)</label><input name="risk_percent" value="<?=h((string)$settings['risk_percent'])?>">
        <label class="muted" style="margin-top:10px">Max trades/day</label><input name="max_trades_per_day" value="<?=h((string)$settings['max_trades_per_day'])?>">
        <label class="muted" style="margin-top:10px">Daily stop %</label><input name="daily_stop_percent" value="<?=h((string)$settings['daily_stop_percent'])?>">
        <label class="muted" style="margin-top:10px">Weekly stop %</label><input name="weekly_stop_percent" value="<?=h((string)$settings['weekly_stop_percent'])?>">
        <label class="muted" style="margin-top:10px">Max open positions</label><input name="max_open_positions" value="<?=h((string)$settings['max_open_positions'])?>">
        <label class="muted" style="margin-top:10px">Min USDT balance to create proposal</label><input name="min_usdt_balance" value="<?=h((string)($settings['min_usdt_balance'] ?? 5.5))?>">
        <label class="muted" style="margin-top:10px">Allowed pairs (comma)</label><textarea name="allowed_pairs"><?=h((string)$settings['allowed_pairs'])?></textarea>
        <button class="btn btn-gray" type="submit" style="margin-top:10px">Save Limits</button>
      </form>
    </div>

    <div class="card col12">
      <h3 style="margin-top:0">Last Trades</h3>
      <table>
        <thead><tr><th>ID</th><th>Pair</th><th>Action</th><th>Status</th><th>Qty (USDT)</th><th>Price</th><th>Time</th></tr></thead>
        <tbody>
          <?php foreach($trades as $t): ?>
          <tr>
            <td><?=h((string)$t['id'])?></td><td><?=h($t['pair'])?></td><td><?=h($t['action'])?></td>
            <td><?=h($t['status'])?></td><td><?=h((string)$t['qty'])?></td><td><?=h((string)$t['price'])?></td><td><?=h($t['created_at'])?></td>
          </tr>
          <?php endforeach; ?>
          <?php if(!$trades): ?><tr><td colspan="7" class="muted">No trades yet.</td></tr><?php endif; ?>
        </tbody>
      </table>
      <div class="muted" style="margin-top:8px">Pending proposals: <b><?=h((string)$pending)?></b></div>
    </div>

    <div class="card col12">
      <h3 style="margin-top:0">Recent Logs</h3>
      <table>
        <thead><tr><th>Time</th><th>Message</th></tr></thead>
        <tbody>
          <?php foreach($logs as $l): ?><tr><td style="width:220px"><?=h($l['created_at'])?></td><td><?=h($l['message'])?></td></tr><?php endforeach; ?>
          <?php if(!$logs): ?><tr><td colspan="2" class="muted">No logs yet.</td></tr><?php endif; ?>
        </tbody>
      </table>
      <div class="muted" style="margin-top:10px">File log: /logs/engine.log (blocked from web)</div>
    </div>
  </div>
</div>
</body></html>
